---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-Menubar - Edit 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/js/Menubar.Edit.js` - Editメニューの実装ファイル（146行）
- E-02: `editor/js/commands/AddObjectCommand.js` - オブジェクト追加コマンド（69行）
- E-03: `editor/js/commands/RemoveObjectCommand.js` - オブジェクト削除コマンド（89行）
- E-04: `editor/js/commands/SetPositionCommand.js` - 位置変更コマンド（85行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Undoメニューはeditor.undo()を呼び出す | E-01 (32-36行目) | ○ |
| C-02 | Redoメニューはeditor.redo()を呼び出す | E-01 (44-48行目) | ○ |
| C-03 | Undoのショートカットキーは CTRL+Z | E-01 (31行目) | ○ |
| C-04 | Redoのショートカットキーは CTRL+SHIFT+Z | E-01 (44行目) | ○ |
| C-05 | Deleteのショートカットキーは DEL | E-01 (127行目) | ○ |
| C-06 | Center処理はBox3.setFromObjectを使用 | E-01 (91行目) | ○ |
| C-07 | Center処理はSetPositionCommandを実行 | E-01 (99行目) | ○ |
| C-08 | Clone処理はSkeletonUtils.cloneを使用 | E-01 (8行目, 115行目) | ○ |
| C-09 | Clone処理はAddObjectCommandを実行 | E-01 (117行目) | ○ |
| C-10 | Delete処理はRemoveObjectCommandを実行 | E-01 (134行目) | ○ |
| C-11 | 履歴変更時にonHistoryChangedが呼ばれる | E-01 (73行目) | ○ |
| C-12 | 履歴がない場合inactiveクラスが適用される | E-01 (59-67行目) | ○ |
| C-13 | オブジェクト未選択時は処理が中止される | E-01 (89行目, 113行目, 132行目) | ○ |
| C-14 | 関連機能にObject3Dが含まれる | E-06 (49行目) | ○ |
| C-15 | 関連機能にVector3が含まれる | E-06 (50行目) | ○ |
| C-16 | 関連機能にBox3が含まれる | E-06 (51行目) | ○ |
| C-17 | AddObjectCommandはexecuteでeditor.addObjectを呼ぶ | E-02 (29行目) | ○ |
| C-18 | RemoveObjectCommandはexecuteでeditor.removeObjectを呼ぶ | E-03 (38行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] Undo/Redo機能の実装が正しく記載されているか
- [x] ショートカットキーの記載が正確か
- [x] Center/Clone/Delete各機能の処理フローが正確か
- [x] 例外処理（未選択時の挙動）が正確か
- [x] 関連機能一覧が画面機能マッピングと一致しているか
